/* ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ******************************************************************************** */

/* ********************* LICENSE STRINGS **********************
#*     To unlock the full functionality of Name Object,        *
#* please call a sales representative at 1-800-MELISSA ext. 3  *
#*         (1-800-635-4772 x3) for a license string.           *
#*  Name Object will not function without a valid              *
#*      			  license string 			          	   *
#************************************************************* */


set pagesize 50000;
set long 20000;
set echo off;
set pages 999;
set serveroutput on;

truncate table log;
commit;

declare
  no pls_integer;
  bno varchar2(100);
  val varchar2(32767);
  ok integer;
counter integer := 0;
  i number := 0;
   err_num NUMBER;
   err_msg VARCHAR2(100);

begin

  no := mdNameCreate();
  insert into log values('created mdName object');
  commit;

  ok := mdNameSetLicenseString(no, 'SET_LICENSE_HERE');
  insert into log values('set license: ok=' || ok);
  commit;

  bno := mdNameGetBuildNumber(no);
  insert into log values('build number= ' || bno);
  commit;

  mdNameSetPathToNameFiles(no, 'SET_PATH_HERE');
  insert into log values('set path to Name files');
  commit;

  ok := mdNameInitializeDataFiles(no);
  insert into log values('init datafiles: error=' || ok);
  commit;

  val := mdNameGetInitializeErrorString(no);
  insert into log values('init error string = ' || val);
  commit;

  val := mdNameGetDatabaseDate(no);
  insert into log values('database date = ' || val);
  commit;

  for rec in (select * from md_apne_table) loop
  BEGIN
    mdNameClearProperties(no);
    	mdNameSetFullName(no, NVL(rec.FULLNAME,' '));
      ok := mdNameParse(no);
    val := (mdNameGetPrefix(no) || ' ' || mdNameGetFirstName(no) || '-' || mdNameGetMiddleName(no) || ' ' || mdNameGetLastName(no) || ' ' || mdNameGetSuffix(no));
   DBMS_OUTPUT.PUT_LINE(val);
   DBMS_OUTPUT.PUT_LINE(counter);
    counter := counter + 1;
    EXCEPTION
       WHEN OTHERS THEN
	  err_num := SQLCODE;
	  err_msg := SUBSTR(SQLERRM, 1, 100);
	  insert into log values('ORA' || err_num || ': ' || err_msg);
	  insert into log values(val);
	  commit;
	  exit;
    END;
  end loop;

  if err_num != -28576
  then
    mdNameDestroy(no);
    insert into log values('destroyed mdName object');
    commit;
  end if;

end;
/
